	PAGE 132
;file: FSKIFACE.ASM, Last edition: 26-OCT-1995
;FSK interface for JVFAX, CODE3 and possibly other packages.
;(c) 1995 Pawel Jalocha, SP9VRC
;Free license is given for radio-amateur usage _only_.
;
;The basic function of this interface is to measure (demodulate) the incoming
;audio frequency and to send out this information through the RS232 port
;at regular intervals.
;
;In July 1995 I have added some support for sending out an FSK modulated
;signal in a fashion compatible with JFVAX.
;
;One comment on the DSPCARD4's noise:
;I still haven't put my card into a metal box, so it makes lot of noise...
;However I have found that connecting two 1nF ceramic capacitors
;from the ground (29,30,31,32,64) to the "-IO" (28) and "+IO" (60) lines
;_greatly_ reduces that noise. I connected the capacitors straight on
;the Euro-connector plug. The numbers given are the pins as on the diagram
;on page 62 of the DSP card 4 User's Manual (Apr-94).
;
; Changes by JBF Feb 13/96
;
	nolist
	include 'leonid'
	include 'ioequlc'
	include 'intequlc'
	list
	title 'FSK interface by SP9VRC'

RedLED  macro mode      ; RedLED clr/set/chg
	b\mode #13,X:$FFE4
	endm

EVM56K          equ 1           ;set to 1 if the program is going to be run
				;on the EVM56002 evaluation board (set J12 to 16K).

;-----------------------------------------------------------------------------
; Select EVM clock speed
; Some 66MHz parts will run up to 80 MHz
;
MHZ32   equ	0	; 32 MHz for most accurate SCI baudrates      *JBF*
MHZ40 	equ	1	; 40 MHz EVM				      *JBF*
MHZ66	equ	0	; 66 MHz EVM				      *JBF*
MHZ80   equ	0	; 80 MHz EVM				      *JBF*
	if EVM56K	   ;					      *JBF*
	if	MHZ32	   ;					      *JBF*
Xtal	equ	32000000   ;					      *JBF*
	endif		   ;					      *JBF*
	if	MHZ40	   ;					      *JBF*
Xtal	equ	40000000   ;					      *JBF*
	endif		   ;					      *JBF*
	if	MHZ66	   ;					      *JBF*
Xtal	equ	68000000   ;					      *JBF*
	endif		   ;					      *JBF*
	if	MHZ80	   ;					      *JBF*
Xtal	equ	80000000   ;					      *JBF*
	endif		   ;					      *JBF*
	else
Xtal            equ 27000000    ;DSP's crystal frequency for DSPCARD4
	endif
			;enable only ONE of the following options:
CODE3           equ 0   ;emulate PLL decoder for CODE3
JVFAX_SSTV      equ 0   ;JVFAX interface for SSTV (untested)
JVFAX_SW        equ 1   ;JVFAX interface for shortwave FAX (+/-400Hz shift)
JVFAX_LW        equ 0   ;JVFAX interface for longwave FAX (+/-150Hz shift)

	if CODE3           ;parameters for a CODE3 PLL-emulator interface
SampleFreq      equ 9600.0

PassFilterLen    equ 64    ;tap-length of the input filter (EVEN number)
			   ;larger length => filter's edge sharper,
			   ;filter's passband more flat,
			   ;better rejection of unwanted frequencies.
PassFilterCenter equ 750.0 ;Filter's center frequency
			   ;This is the center of my CW filter
PassFilterWidth equ 400.0  ;consult clever books :-) on how much bandwidth
			   ;is needed for a particular modulation.
CarFreq         equ 750.0  ;Tx carrier/Rx center frequency
			   ;ussually same as PassFilterCenter
CarDev          equ 100.0  ;Tx and Rx deviation

RxOutScale      equ 1.35   ;adjust this such that your application
			   ;shows the correct frequency shift
			   ;this is simply the coefficiant between
			   ;the FM demodulator output and the byte value
			   ;being sent out via RS232 port.

BitFilterLen    equ 128 ;Post-detection filtering for Rx
			;and pre-modulation filtering for Tx
			;128 is about optimal for 100 baud

NewBaudRate     equ 0           ;new baud rate for the serial port
				;default is 19200 as set by LEONID
			;Note, that when you change the baud rate
			;and want to download a program you need
			;to reset the DSPCARD4 so the serial port
			;is restored to original settings.
			;Note too that changing the baud rate changes
			;the watchdog "push" and the green LED blinking rate
			;propotionally. Too low baudrate may be a reason
			;for the watchdog forcing a reset.

SmoothTransmit equ 1    ;pre-filter the data before applying
			;to the FM modulator
TransmitHold   equ 0    ;time to hold the transmitter audio
			;after the last data is received on the serial port
			;0 disables the transmitter

BufLen  equ  PassFilterLen+32      ;sample buffer length
BatchLen equ     8      ;processing batch length
			;BatchLen determines as well the data output rate
BatchLenLog equ  3      ;BatchLen = 2 ^ BatchLenLog
	endif

	if JVFAX_SSTV       ;parameters for a JVFAX serial port/serial
			    ;for SSTV
SampleFreq      equ 9600.0

PassFilterLen    equ 64
PassFilterCenter equ 1800.0 ;FAX center frequency
PassFilterWidth equ 2000.0  ;consult clever books...

CarFreq         equ 1750.0  ;we should cover the range 1200 - 2300 Hz
CarDev          equ 550.0   ;

RxOutScale      equ 6.28    ;this factor gives about full swing between 0 and 255
			    ;on output for a deviation = +/-CarDev

BitFilterLen    equ 2       ;longer post-detection filter => less noise
			    ;but the picture gets smeared out more.

;NewBaudRate     equ 38400   ;FAX needs lot of pixels/second thus we need
NewBaudRate     equ 57600   ;FAX needs lot of pixels/second thus we need
			    ;this high speed on the serial port
			    ;57600 would be very nice, but the 27MHz crystal
			    ;does not allow for this.

SmoothTransmit equ 1    ;pre-filter the data before applying
			;to the FM modulator
TransmitHold   equ 100  ;time to hold the transmitter audio
			;after the last data is received on the serial port
			;0 disables the transmitter

BufLen  equ  PassFilterLen+32      ;sample buffer length

BatchLen equ     1      ;processing batch length
			;this determines that we send bytes out
			;9600/2 = 4800 times per second.
BatchLenLog equ  0      ;BatchLen = 2 ^ BatchLenLog

	endif

	if JVFAX_SW         ;parameters for a JVFAX serial port/serial
			    ;for a standard short-wave FAX
SampleFreq      equ 9600.0

PassFilterLen    equ 64
PassFilterCenter equ 1800.0 ;FAX center frequency
PassFilterWidth equ 2000.0  ;consult clever books...

CarFreq         equ 1800.0  ;1800 or 1900 Hz ?
CarDev          equ 400.0   ;FAX deviation for standard shortwave FAX

RxOutScale      equ 6.28    ;this factor gives about full swing between 0 and 255
			    ;on output for a deviation = +/-CarDev

BitFilterLen    equ 2       ;longer post-detection filter => less noise
			    ;but the picture gets smeared out more.

;NewBaudRate     equ 38400   ;FAX needs lot of pixels/second thus we need
NewBaudRate     equ 57600   ;FAX needs lot of pixels/second thus we need
			    ;this high speed on the serial port
			    ;57600 would be very nice, but the 27MHz crystal
			    ;does not allow for this.

SmoothTransmit equ 1    ;pre-filter the data before applying
			;to the FM modulator
TransmitHold   equ 100  ;time to hold the transmitter audio
			;after the last data is received on the serial port
			;0 disables the transmitter

BufLen  equ  PassFilterLen+32      ;sample buffer length

BatchLen equ     2      ;processing batch length
BatchLenLog equ  0      ;BatchLen = 2 ^ BatchLenLog

	endif

	if JVFAX_LW         ;parameters for a JVFAX serial port/serial
			    ;for a standard long-wave FAX
SampleFreq      equ 9600.0

PassFilterLen    equ 64
PassFilterCenter equ 1800.0 ;FAX center frequency
PassFilterWidth equ 1800.0  ;consult clever books...
			    ;lower width => more noise but more
			    ;resolution/accuracy in the picture.
			    ;For lower LPM you can make the width narrower
			    ;for a given resolution.

CarFreq         equ 1800.0
CarDev          equ 150.0   ;FAX deviation for standard longwave FAX

RxOutScale      equ 6.28    ;this factor gives about full swing between 0 and 255
			    ;on output for a deviation = +/-CarDev

BitFilterLen    equ 2

;NewBaudRate     equ 38400   ;FAX needs lot of pixels/second thus we need
NewBaudRate     equ 57600

SmoothTransmit equ 1    ;pre-filter the data before applying
			;to the FM modulator
TransmitHold   equ 100  ;time to hold the transmitter audio
			;after the last data is received on the serial port
			;0 disables the transmitter

BufLen  equ  PassFilterLen+32      ;sample buffer length
BatchLen equ     1      ;processing batch length
BatchLenLog equ  0      ;BatchLen = 2 ^ BatchLenLog
	endif


DCrise     equ  512     ;DC rise time in samples
			;the larger, the slower the DC follows
RMSrise    equ  512     ;RMS rise time in samples
			;the larger, the slower the RMS follows

InpGain    equ 10.0     ;CODEC's input gain in dB's
AGCenable  equ 0        ;automatic adjustment of the input amplification
AGCstereo  equ 0        ;take both or only the left channel for the AGC
AGCalert   equ 0        ;indicate too low or too high audio levels with the red LED

AGChold  equ  9600      ;AGC hold time in samples
AGCfall  equ  512       ;AGC fall time in samples/AGC unit (1.5dB)
RMSmin   equ 0.050      ;minimum and maximum RMS values for the front-end AGC
RMSmax   equ 0.200      ;do not make these closer than by a factor of 2
			;the RMSes are indeed MSes that without the square root

SPY     equ 0           ;for spying on the FM-demodulator output


	LOMEM P:$0000
	HIMEM P:$1FFF

	org p:user_code

;        andi #%11110011,mr      ;scaling bits = 00

	move #Buffer,r2          ;for us to address the input and output samples
	move #<4-1,n2
	move #BufLen*4-1,m2

	move #RxBitFilterTap,r6
	move #BitFilterLen-1,m6
	move #TxBitFilter-RxBitFilter,n6

	move #Buffer+2,r7        ;r7 for the CODEC's interrupt routine
	move #BufLen*4-1,m7

			;initialize input/output control words in the buffer
			;zero input/output data
      if EVM56K ;for the EVM56002 use the microphone input
	ctrlcd  1,r2,BufLen,MIC,InpGain,InpGain,LINEO|HEADP,20.0,20.0
      else      ;for the DSPCARD4 use the LINE input
	ctrlcd  1,r2,BufLen,LINEI,InpGain,InpGain,LINEO|HEADP,20.0,20.0
      endif
	opencd SampleFreq/1000.0,HPF    ;start taking samples at given rate
;
; Changed order of CODEC buffer initialization and SCI baudrate setup *JBF*
;
	if !SPY								  
	  bclr #12,X:<<$FFF0    ;disable SCI Tx interrupts		  
	  bclr #11,X:<<$FFF0    ;disable SCI Rx interrupts		  
	  if NewBaudRate        ;set new baud rate (copied from LEONID)	  
	   jclr #0,X:<<$FFF1,*  ;wait until all data is sent out	  
	   movep #(Xtal+2*16*NewBaudRate)/(2*2*16*NewBaudRate)-1,X:<<$FFF2
	  endif								  
	endif								  


BatchLoop
	waitblk r2,BufLen,BatchLen      ;wait till enough samples for one batch
					;the following code should use r2
					;for addressing the samples
					;r7,m7 must not be used: SSI interrupts
					;r3,m3 must not be used: SCI interrupts and LEONID code
				
				;compute DC levels
	clr a  r2,x1            ;clear sums, save r2
	clr b  X:(r2)+,x0
	if BatchLen>1
	.loop #BatchLen-1       ;average samples with the batch
	  add x0,a X:(r2)+n2,x0
	  add x0,b X:(r2)+,x0
	.endl
	endif
	add x0,a X:(r2)+n2,x0
	add x0,b
	move x1,r2              ;restore r2

	if BatchLenLog>0
	.loop #BatchLenLog      ;scale the average
	  asr a
	  asr b
	.endl           ;now: a = left DC, b = right DC
	endif

	rnd a #(1.0-1.0/DCrise*BatchLen),y0           ;futher DC filter
	rnd b #1.0/DCrise*BatchLen,y1
	move Y:<DCleft,x0
	mpy x0,y0,a  a,x0
	macr x0,y1,a  Y:<DCright,x0
	mpy x0,y0,b  b,x0
	macr x0,y1,b  a,Y:<DCleft
	move b,Y:<DCright
			;now subtract the DCs from the data
	move a,y0
	move b,y1  X:(r2),a
	move r2,x1      ;save r2
	.loop #BatchLen
	  sub y0,a
	  move a,X:(r2)+
	  move X:(r2),b
	  sub y1,b  X:(r2+n2),a
	  move b,X:(r2)+n2
	.endl
	move x1,r2              ;restore r2

				;sum up the RMSes of both channels
	clr a  r2,x1            ;clear sums, save r2
	clr b  X:(r2)+,x0
	if BatchLen>1
	.loop #BatchLen-1       ;sum up the signal squares
	  mac x0,x0,a X:(r2)+n2,x0
	  mac x0,x0,b X:(r2)+,x0
	.endl
	endif
	mac x0,x0,a X:(r2)+n2,x0
	mac x0,x0,b
	move x1,r2              ;restore r2

	if BatchLenLog>0
	.loop #BatchLenLog      ;divide by BatchLen
	  asr a
	  asr b
	.endl           ;now: a = left RMS, b = right RMS
	endif
	
	rnd a #(1.0-1.0/RMSrise*BatchLen),y0  ; filter these RMSes to get smoother rise/fall
	rnd b #1.0/RMSrise*BatchLen,y1
	move X:<RMSleft,x0
	mpy x0,y0,a  a,x0
	macr x0,y1,a  X:<RMSright,x0
	mpy x0,y0,b  b,x0
	macr x0,y1,b  a,X:<RMSleft
	move b,X:<RMSright

	if AGCenable
	
CheckRMSmin                     ;are the RMSes below the minimum required ?
	move #RMSmin,x0
	cmp x0,a
	jcc <CheckRMSmax
	if AGCstereo
	  cmp x0,b
	  jcc <CheckRMSmax
	endif
GainUp                          ;if so, increase the CODEC's input gain
	move X:<AGCcount,a      ;decrement the timeout
	move #>BatchLen,x0
	sub x0,a  #>AGCfall,x0
	move a,X:<AGCcount
	jgt <CheckRMS_OK        ;leave if not yet zero
	clr a  x0,X:AGCcount
	move Y:(r2),a1          ;get the CODEC's input control word
	move #>$0F0F00,x0
	and x0,a                ;extract the gain
	cmp x0,a  #>$010100,x0  ;already maximum ?
	jeq <RMS_Alert          ;if so flash the red LED
	add x0,a  #>$F0F000,x0  ;if not, increment the gain by 1
	move a1,x1
	move Y:(r2),a1          ;and reload all the control words
	and x0,a  n2,x0         ;in the output buffer
	or x1,a  #<4,n2         ;make n2=4 for a moment
	.loop #BufLen
	  move a1,Y:(r2)+n2
	.endl
	move x0,n2              ;restore n2
	move #0.7071,y0         ;increase the RMSes to follow the gain
	move X:RMSleft,x0       ;increase faster
	mpyr x0,y0,a  
	asl a  X:<RMSright,x0
	mpyr x0,y0,a a,X:<RMSleft
	asl a
	move a,X:<RMSright
	jmp <CheckRMS_OK

CheckRMSmax                     ;are the RMSes above the given maximum
	move #>AGChold,x0       ;initialize the AGC hold count-down
	move x0,X:<AGCcount
	move #RMSmax,x0
	cmp x0,a                ;compare left and right RMS
	if AGCstereo
	  jcc <GainDown
	  cmp x0,b
	endif  
	jcs <CheckRMS_OK
GainDown                        ;if the RMSes are too high
	clr a                   ;decrease the CODEC's input gain
	move Y:(r2),a1          ;get the CODEC's input control word
	move #>$0F0F00,x0
	and x0,a  #>$010100,x0  ;extract the gain bits
	sub x0,a  #>$F0F000,x0  ;attempt to decrease the gain
	jcs <RMS_Alert          ;jump if overflow
	move a1,x1
	move Y:(r2),a1          ;reload all the input control words
	and x0,a  n2,x0         ;in the buffer with the new input gain
	or x1,a  #<4,n2         ;n2=4 for a moment
	.loop #BufLen
	  move a1,Y:(r2)+n2
	.endl
	move x0,n2              ;restore n2
	move #0.7071,y0         ;decrease the RMSes to follow expected
	move X:<RMSleft,x0       ;gain reduction faster
	mpyr x0,y0,a  X:<RMSright,x0
	mpyr x0,y0,a a,X:<RMSleft
	move a,X:<RMSright
	jmp <CheckRMS_OK

RMS_Alert
	if AGCalert
	  RedLED set
	endif
	jmp <CheckRMSend

CheckRMS_OK
	if AGCalert
	  RedLED clr
	endif
CheckRMSend
	
	endif   ; of AGCenable

Process

      if BatchLen>1
	.loop #BatchLen
      endif

;Receiver part
	  move X:<RxCarPhase,x0  ;get the receiver carrier phase
	  move X:<RxCarFreq,a    ;advance the phase
	  add x0,a
	  move a1,X:<RxCarPhase
	  jsr <IQ               ;compute I and Q (modifies a,b,x,y,r0,m0,n0)
	  move a,X:<RxCarI      ;save cosine
	  move b,X:<RxCarQ      ;save sine

					;input filtering
	  move n2,y1
	  move #4*(PassFilterLen-1),n2
	  move #PassFilterI,r4
	  move (r2)-n2
	  move #<4,n2
	  move #PassFilterLen-1,m4
	  move r2,x1                      ;save r2
	  clr a X:(r2)+n2,x0 Y:(r4)+,y0
	  .loop #PassFilterLen-1
	    mac x0,y0,a X:(r2)+n2,x0  Y:(r4)+,y0
	  .endl
	  mac x0,y0,a  #PassFilterQ,r4
	  move x1,r2
	  nop
	  clr b X:(r2)+n2,x0 Y:(r4)+,y0
	  .loop #PassFilterLen-1
	    mac x0,y0,b X:(r2)+n2,x0  Y:(r4)+,y0
	  .endl
	  mac x0,y0,b x1,r2     ;a,b = filtered sample (I and Q)
	  move y1,n2

	  jsr <NormIQ           ;normalize (remove amplitude variations)
	  move a,x0             ;mix with the carrier
	  move b,y0
	  move X:<RxCarI,x1
	  move X:<RxCarQ,y1
	  mpy x0,x1,a
	  macr y0,y1,a          ;a = demodulated I
	  mpy x0,y1,b
	  macr -x1,y0,b         ;b = demodulated Q

;        jmp <TxAudio    ;*** DEBUG ***

	  move          a,y0       ;see by how much the phase changed
	  mpy y0,y0,b   b,y1       ;with respect to the previous sample
	  move          X:<RxI,x0
	  mpy -x0,y1,a  y0,X:<RxI
	  mac x0,x0,b   X:<RxQ,x1
	  macr x1,y0,a  y1,X:<RxQ  ;a = FM demodulator output
	  asr a x1,x0              ; = phase shift between two consecutive I-Q samples
	  mac x0,x0,b  y1,y0
	  mac y0,y0,b
	  asr b
	  rnd b                 ;b = amplitude square, = reference for FM output

	  move a,Y:(r6)+n6      ;place the demodulated signal in the Rx
				;filter tap and switch r6 to the Tx filter
;Transmitter part
;at this point we should generate a new output data sample

      if TransmitHold
	move X:<TxHoldCount,a   ;if HoldCount at zero, then
	tst a                   ;output=0
	jeq <TxAudio
      else                      ;if transmitting is disabled
	clr a                   ;then keep quiet all the time
	jmp <TxAudio
      endif

	move X:<TxLevel,a
TxSample                        ;a = new data sample (+1 to -1)
	if SmoothTransmit
	  move #TxBitFilter,r0  ;aply the bit-filter
	  move #BitFilterLen-1,m0
	  move a,Y:(r6)         ;put new data sample into the bit-filter tap
	  clr a  X:(r0)+,x0 Y:(r6)+,y0  ;filter the Tx data tap
	  .loop #BitFilterLen-1
	    mac x0,y0,a X:(r0)+,x0 Y:(r6)+,y0
	  .endl
	  macr x0,y0,a          ;a=filtered data
	endif

	move a,x0               ;
	move #2.0*CarDev/SampleFreq,y0
	mpyr x0,y0,a #2.0*CarFreq/SampleFreq,x0  ;a = instant carrier deviation
	add x0,a
	move a,X:<TxCarFreq     ;update the instant carrier frequency
	move X:<TxCarPhase,x0   ;get the carrier phase
	add x0,a                ;and advance it
	move a1,X:<TxCarPhase
	jsr <IQ                 ;compute the sin/cos (modifies a,b,x,y,r0,m0,n0)

TxAudio                         ;output filtering
	move #PassFilterOut,r4
	move #PassFilterLen-1,m4
	asr a  (r2)+
	move a,y1
	.loop #PassFilterLen-1
	  move X:(r4)+,x0 Y:(r2),a
	  macr x0,y1,a
	  move a,Y:(r2)+
	  move a,Y:(r2)+n2
	.endl
	.loop #1
	  move X:(r4)+,x0
	  mpyr x0,y1,a
	  move a,Y:(r2)+
	  move a,Y:(r2)+n2
	.endl
	move (r2)-

	move (r6)-n6
	move (r6)-

      if BatchLen>1
	.endl
      endif

	move #RxBitFilter,r0  ;apply the bit-filter
	move #BitFilterLen-1,m0
	nop
	clr a  X:(r0)+,x0 Y:(r6)+,y0  ;filter the Rx data tap
	.loop #BitFilterLen-1
	  mac x0,y0,a  X:(r0)+,x0 Y:(r6)+,y0
	.endl
	macr x0,y0,a        ;a=filtered data

;          move Y:(r6),a ;*** DEBUG ***

	if SPY
	  jsr <SpyA
	else
	  move a,y0             ;scale the output data
	  move #>RxOutScale/32768.0,x0
	  mpyr x0,y0,a #>$80,x0
	  add x0,a #<0,x0       ;limit the data to 0..$FF range
	  tlt x0,a
	  move #>$FF,x0
	  cmp x0,a
	  tgt x0,a
;          jclr #1,X:<<$FFF1,RxData_end  ;serial Tx ready ?
	  jclr #0,X:<<$FFF1,RxData_end  ;serial Tx empty ?
	    movep a1,X:<<$FFF4    ;output the data to the serial port
RxData_end

	if TransmitHold
	  move X:<TxHoldCount,b
TxReadData
	  jclr #2,X:<<$FFF1,TxNoData ;anything received on the serial port ?
	  jset #4,X:<<$FFF1,TxDataErr ;if overrun error
;          jset #5,X:<<$FFF1,TxDataErr ;if parity error
	  jset #6,X:<<$FFF1,TxDataErr ;if framing error
	  movep X:<<$FFF6,a     ;read the byte we got on the serial port
	  move #<0,x0
	  cmp x0,a  #<63,x0     ;below 0 ?
	  jlt <TxReadData       ;then ignore it
	  cmp x0,a  #<32,x0     ;above 63 ?
	  jgt <TxReadData       ;then ignore it too
	  sub x0,a              ;scale to the range -1.0..+1.0
	  asl a
	  asl a #>TransmitHold+1,b ;set hold counter
	  move a,X:<TxLevel     ;set the modulator input
	if !EVM56K
	  bset #0,X:<<$FFE4     ;Turn on the PTT
	endif
	  jmp <TxReadData       ;check for more data...

TxDataErr movep X:<<$FFF6,a     ;read the serial port just to clear the error
	  jmp <TxReadData

TxNoData                        ;decrement the hold counter
	  tst b #>1,x0
	  jeq <TxData_end
	  sub x0,b
	  jgt <TxData_end       ;still above zero ?
	if !EVM56K
	  bclr #0,X:<<$FFE4     ;Turn off the PTT if not
	endif
TxData_end
	  move b,X:<TxHoldCount

	endif

	endif

	jmp     <BatchLoop

PI      equ     3.14159265358979323846
EX      equ     2.718281745911

;this routine computes a cosine/sine pair using the sine ROM
;with a second order (linear+quadrature) approximation between table points
IQ                              ;x0 = angle ( -1 = -PI, +1 = +PI)
	move #>$80,x1   ;shift out 8 most significant bits
	mpy x0,x1,a  #>$FF,x0
	ori #%00000011,mr       ;disable interrupts
	move x0,m0
	and x0,a     #>$100,x0
	or x0,a      #<$40,n0
	ori #%00000100,omr      ;enable the sine ROM table
	move a1,r0      ;put the 8 most significant bits into r0 with offset = $100
	move a0,y0      ;save the remaining bits in y0
	jclr #23,y0,SinTable
	  move (r0)+
SinTable
	move Y:(r0+n0),x0       ;x0 = coarse cosine
	move Y:(r0),x1          ;x1 = coarse sine
	mpyr x1,y0,a  #PI/256.0,y1
	tfr x0,a  a,x1
	macr -x1,y1,a           ;a = fine cosine
	mpyr x0,y0,b  Y:(r0),x1
	andi #%11111011,omr     ;disable the sine ROM table
	tfr x1,b  b,x1
	macr x1,y1,b  #PI*PI/2.0/65536.0,y1  ;b = fine sine
	mpyr y0,y0,a  a,x0
	andi #%11111100,mr      ;enable interrupts
	move a,y0
	mpyr y0,y1,a
	tfr x0,a  a,y1
	macr -x0,y1,a  b,x1     ;a = super fine cosine
	macr -x1,y1,b           ;b = super fine sine
	rts                     ;x,y are modified
				;r0,m0,n0 are modified
				;maximum error is about 0.7E-6
				;execution time 4+64+4 clock cycles
				;including "jsr <IQ" and "rts"
;enable/disable interrupts must be there if interrupt routines
;are accesing RAM at Y:$100..$1FF (like CODEC input/output buffers)

;normalize I,Q such that: I*I + Q*Q = 1.0
NormIQ                  ;a=I, b=Q
	cmpm a,b
	jge <NormAftB
	tst a
	jes <RightA
	jnr <FineNorm
LeftA     asl b
	  asl a
	jnn <LeftA
FineNorm
	move a,x0
	move b,y0
	.loop #5        ;4 is already just about perfect
	  move #-1.0,a
	  mac x0,x0,a
	  mac y0,y0,a
	  asr a
	  tfr x0,a  a,x1
	  macr -x0,x1,a
	  tfr y0,a  a,x0
	  macr -y0,x1,a
	  move a,y0
	.endl
	move x0,a
	move y0,b
	rts             ;result: a=I, b=Q; modifies x,y
			;execution time: about 180 clock cycles.
RightA    asr b
	  asr a
	jes <RightA
	jmp <FineNorm

NormAftB
	tst b
	jes <RightB
	jnr <FineNorm
LeftB     asl a
	  asl b
	jnn <LeftB
	jmp <FineNorm
RightB    asr a
	  asr b
	jes <RightB
	jmp <FineNorm

	if SPY

SpyA    move a10,L:<SpySave
	move a2,X:<SpySave+1
	move x0,Y:<SpySave+1
	move x1,Y:<SpyCount
	move X:<SpyCount,a
	tst a
	jne <Spy_copy

Spy_check
	lookc
	jcs <Spy_end
	move #>'S',a
	cmp x0,a
	jne <Spy_end
	move #>'P',x0
	putc
	move #>512,a
Spy_copy
	move #>1,x0
	sub x0,a
	move a,X:<SpyCount

	move X:<SpySave,a
	rep     #8
	lsr     a
	move    a1,x0
	putc
	move X:<SpySave,a
	rep     #16
	lsr     a
	move    a1,x0
	putc

Spy_end move L:<SpySave,a10
	move X:<SpySave+1,a2
	move Y:<SpySave+1,x0
	move Y:<SpyCount,x1
	rts

	endif

;Internal RAM allocations

	LOMEM X:$0000,Y:$0000,L:$0000
	HIMEM X:$00FF,Y:$00FF,L:$00FF

	org L:user_data

	if SPY
SpySave dc 0,0
SpyCount dc 0
	endif

LastL = *

	org X:LastL
	org Y:LastL

	org Y:
DCleft  dc 0            ;DC bias for both channels
DCright dc 0
	
	org X:
RMSleft  dc 0           ;RMS (energy) for both channels
RMSright dc 0

	org X:
AGCcount dc 0           ;counter for the AGC hold-off

	org X:
TxCarFreq  dc 2*CarFreq/SampleFreq  ;transmitter carrier frequency and phase
TxCarPhase dc 0

TxRxState  dc 0         ;bit #0: 1 = transmitter on, 0 = off

TxLevel    dc 0         ;actuall Tx modulator level
TxHoldCount dc 0

	org X:
RxCarFreq   dc 2*CarFreq/SampleFreq
RxCarPhase  dc 0
RxCarI dc 0     ;cos/sin of RxCarPhase
RxCarQ dc 0
RxI    dc 0     ;most recent I-Q vector
RxQ    dc 0

;External RAM allocations

	if EVM56K
	  LOMEM X:$2000,Y:$0100,L:$2000
	  HIMEM X:$3FFF,Y:$3FFF,L:$3FFF
	else
	  LOMEM X:$0100,Y:$0100,L:$0100
	  HIMEM X:$1FFF,Y:$3FFF,L:$1FFF
	endif

	if EVM56K
	  org L:$2000
	else
	  org L:$200
	endif
Buffer   dsm BufLen*4   ;CODEC's input/output buffer

LastL = *
	org X:LastL
	org Y:LastL

	org Y:
PassFilterI dsm PassFilterLen ;anti-alias input filter (I and Q)
PassFilterQ dsm PassFilterLen

	org X:
PassFilterOut dsm PassFilterLen

	org X:
RxBitFilter dsm BitFilterLen
TxBitFilter dsm BitFilterLen

	org Y:
RxBitFilterTap dsm BitFilterLen
TxBitFilterTap dsm BitFilterLen


LowFreq = (PassFilterCenter-PassFilterWidth/2)/SampleFreq
UppFreq = (PassFilterCenter+PassFilterWidth/2)/SampleFreq

	org Y:PassFilterI

time = -@cvf(PassFilterLen/2)+0.5
count   set 0
	dup PassFilterLen
Window = 0.75*@cos((time/@cvf(PassFilterLen))*PI)+0.25*@cos(3*(time/@cvf(PassFilterLen))*PI)
Filter = (@sin(2.0*PI*time*UppFreq)-@sin(2.0*PI*time*LowFreq))/(PI*time)
time = time+1.0
	dc Window*Filter
count   set count+1
	endm

	org Y:PassFilterQ

time = -@cvf(PassFilterLen/2)+0.5
count   set 0
	dup PassFilterLen
Window = 0.75*@cos((time/@cvf(PassFilterLen))*PI)+0.25*@cos(3*(time/@cvf(PassFilterLen))*PI)
Filter = (@cos(2.0*PI*time*UppFreq)-@cos(2.0*PI*time*LowFreq))/(PI*time)
time = time+1.0
	dc Window*Filter
count   set count+1
	endm

	org X:PassFilterOut

time = -@cvf(PassFilterLen/2)+0.5
count   set 0
	dup PassFilterLen
Window = 0.75*@cos((time/@cvf(PassFilterLen))*PI)+0.25*@cos(3*(time/@cvf(PassFilterLen))*PI)
Filter = (@sin(2.0*PI*time*UppFreq)-@sin(2.0*PI*time*LowFreq))/(PI*time)
time = time+1.0
	dc  Window*Filter
count   set count+1
	endm

	org X:RxBitFilter

;sigma = @cvf(BitFilterLen)/2.0/6.0

time = -@cvf(BitFilterLen/2)+0.5
count   set 0
	dup BitFilterLen
Filter = 0.75*@cos(PI*time/@cvf(BitFilterLen))+0.25*@cos(3*PI*time/@cvf(BitFilterLen))
;Filter = @pow(EX,-time*time/(2.0*sigma*sigma))
time = time+1.0
	dc Filter/(BitFilterLen)*(SampleFreq/2.0/CarDev)/8.0
count   set count+1
	endm

	org X:TxBitFilter

time = -@cvf(BitFilterLen/2)+0.5
count   set 0
	dup BitFilterLen
Filter = 0.75*@cos(PI*time/@cvf(BitFilterLen))+0.25*@cos(3*PI*time/@cvf(BitFilterLen))
time = time+1.0
	dc  Filter/(BitFilterLen/2)
count   set count+1
	endm

	end



